#!/usr/bin/env python
# -*- coding: utf-8 -*-

import es
from playerlib import getPlayerList, getPlayer
from usermsg import saytext2

info = es.AddonInfo()
info.name = 'Color MSG'
info.version = '2.0.3'
info.url = 'http://addons.eventscripts.com/addons/user/43738'
info.basename = 'cmsg'
info.author = 'maniek23'
info.description   = "Allows easy use of red, blue, and white colors on server"

def load():
	if not es.exists('command', 'cmsg'):
		es.regcmd('cmsg', 'cmsg/cmsg_cmd', 'Usage: cmsg <text>')
	if not es.exists('command', 'ctell'):
		es.regcmd('ctell', 'cmsg/ctell_cmd', 'Usage: ctell <target> <text>')
	
	var = es.ServerVar("%s_pubvar" % info.basename)
	var.set("%s by %s - v. %s" % (info.name, info.author, info.version))
	var.makepublic()
	var = es.ServerVar("%s_version" % info.basename)
	var.set( "%s" % info.version)
	var.makepublic()
	
def unload():
	pass
	
def cmsg(*text):
	ctell(es.getUseridList(), *text)
	
def ctell(target, *text):
	if isinstance(target, int):
		target = [target]
	elif isinstance(target, str):
		target = getUseridList(target)
		
	text = " ".join(text)
	text = text.replace('#multi', '')
	text = text.replace('#yellow', '#default')
	text = text.strip()
	GetIndex = lambda f: len(getPlayerList(f)) > 0 and getPlayerList(f)[0].attributes['index'] or 999
		
	if text.find('#red') > text.find('#blue') and text.find('#red') > text.find('#white'):
		index = GetIndex('#t')
	elif text.find('#blue') > text.find('#red') and text.find('#blue') > text.find('#white'):
		index = GetIndex('#ct')
	elif text.find('#white') > text.find('#red') and text.find('#white') > text.find('#blue'):
		index = GetIndex('#spec')
	else:
		index = None
		
	if index != None:
		text = text.replace('#red', '\x03').replace('#blue', '\x03').replace('#white', '\x03')
		text = text.replace('#green', '\x04').replace('#lightgreen', '\x04')
		text = text.replace('#default', '\x01')
		saytext2(target, index, text)
	else:
		text = text.replace('#red', '#lightgreen').replace('#blue', '#lightgreen').replace('#white', '#lightgreen')
		for u in target:
			es.tell(u, '#multi', text)
	
def cmsg_cmd():
	if es.getargc() < 2:
		es.dbgmsg(0, 'Usage: cmsg <text>')
	cmsg(*map(es.getargv, range(1, es.getargc())))
	
def ctell_cmd():
	if es.getargc() < 3:
		es.dbgmsg(0, 'Usage: ctell <target> <text>')
	target = es.getargv(1)
	if isinstance(target, str) and target.isdigit():
		target = int(target)
	ctell(target, *map(es.getargv, range(2, es.getargc())))
