#######################################################################################################################
# Name:        StickyNades v2.2a                                                                                      #
#                                                                                                                     #
# Author:      JoeyT2008                                                                                              #
#                                                                                                                     #
# Description: Makes grenades stick to walls and players.                                                             #
#                                                                                                                     #
# Problems:    1. When a grenade sticks to someone, it doesn't always stick in the right place...                     #
#                                                                                                                     #
# Notes:       1. To make a grenade stick to yourself, aim down and throw a grenade, it will then stick to your feet. #
#              2. The model for the nade is from TF2, I only recompiled it for CSS.                                   #
#                                                                                                                     #
# Credits:     Creator         JoeyT2008                                                                              #
#                                                                                                                     #
#              Idea            JoeyT2008                                                                              #
#                                                                                                                     #
#              Help            Errant                                                                                 #
#                              Saul                                                                                   #
#                              Lobe                                                                                   #
#                              Ajurna                                                                                 #
#                              Mattie                                                                                 #
#                              Superdave                                                                              #
#                              Wonder                                                                                 #
#                              GODJonez                                                                               #
#                              MBChrono                                                                               #
#                              GLitched System                                                                        #
#                              Venjax                                                                                 #
#                                                                                                                     #
#              Testing         Saul                                                                                   #
#                              mupet0000                                                                              #
#                              Errant                                                                                 #
#                                                                                                                     #
#              Parent Code     Wonder (from Venjax's emote mod) - Fixed by Errant                                     #
#                                                                                                                     #
#              Nade Model      Valve                                                                                  #
#                                                                                                                     #
#              Various CMD's   Everyone on IRC                                                                        #
#######################################################################################################################

import es, gamethread, vecmath, playerlib, random

info = es.AddonInfo()
info.name = "StickyNades"
info.version = "2.2a"
info.author = "JoeyT2008"
info.url = "http://forums.mattie.info/cs/forums/viewtopic.php?t=17799"
info.description = "Allows grenades to stick to walls and players!"
info.basename = "stickynades"

oldEntList = {}
vPrepared = []
tVars = {}

######################
# START EDITING HERE #
######################

# Make HE Grenades stick to selected objects? 1=YES, 0=NO
tVars["sn_hegrenade_enabled"] = 1

# Make HE Grenades stick to walls? 1=YES, 0=NO
tVars["sn_hegrenade_stick_to_walls"] = 1

# Make HE Grenades stick to players? 1=YES, 0=NO
tVars["sn_hegrenade_stick_to_players"] = 1

# Make HE Grenades stick to the thrower of the grenade? 1=YES, 0=NO
tVars["sn_hegrenade_stick_to_thrower"] = 0

# Make Flashbangs stick to selected objects? 1=YES, 0=NO
tVars["sn_flashbang_enabled"] = 1

# Make Flashbangs stick to walls? 1=YES, 0=NO
tVars["sn_flashbang_stick_to_walls"] = 1

# Make Flashbangs stick to players? 1=YES, 0=NO
tVars["sn_flashbang_stick_to_players"] = 1

# Make Flashbangs stick to the thrower of the grenade? 1=YES, 0=NO
tVars["sn_flashbang_stick_to_thrower"] = 0

# Power of a frag grenade when not stuck to a player. Default: 100
tVars["sn_hegrenade_normal_power"] = 100

# Radius of a frag grenade when not stuck to a player. Default: 350
tVars["sn_hegrenade_normal_radius"] = 350

# Power of a frag grenade when stuck to a player. Default: 100
tVars["sn_hegrenade_stuck_power"] = 300

# Radius of a frag grenade when stuck to a player. Default: 350
tVars["sn_hegrenade_stuck_radius"] = 350

# Use a custom model for hegrenades? 1=YES, 0=NO
tVars["sn_hegrenade_model"] = 1

# Play sounds when a player gets stuck? 1=YES, 0=NO
tVars["sn_emit_sounds"] = 1

# Shake player when hit by a stickynade? 1=YES, 0=NO
tVars["sn_shake"] = 1

# Force players to download models, materials and sounds? 1=YES, 0=NO
tVars["sn_downloads"] = 1

# Display StickyNades information on round start? 1=YES, 0=NO
tVars["sn_notice"] = 1

#####################
# STOP EDITING HERE #
#####################

vVars = {}
for var in tVars: vVars[var] = es.ServerVar(var, tVars[var])

es.ServerVar("stickynades_ver", info.version, "Version of StickyNades this server is currently using.").makepublic()

def load():
    if not es.ServerVar("eventscripts_currentmap") == "":
        forceDownloads()
        precacheModels()
    es.addons.registerTickListener(tickSticky)

def unload():
    es.addons.unregisterTickListener(tickSticky)

def es_map_start(event_var):
    forceDownloads()
    precacheModels()

def precacheModels():
    global sn_redmodel, sn_bluemodel
    sn_redmodel = es.precachemodel("models/stickynades/stickynades_red.mdl")
    sn_bluemodel = es.precachemodel("models/stickynades/stickynades_blue.mdl")

def forceDownloads():
    sounds = ["sound/stickynades/muhahaha.wav", "sound/stickynades/scream.wav"]
    models = ["models/stickynades/stickynades_red.dx80.vtx", "models/stickynades/stickynades_red.dx90.vtx", "models/stickynades/stickynades_red.mdl", "models/stickynades/stickynades_red.phy", "models/stickynades/stickynades_red.sw.vtx", "models/stickynades/stickynades_red.vvd", "models/stickynades/stickynades_blue.dx80.vtx", "models/stickynades/stickynades_blue.dx90.vtx", "models/stickynades/stickynades_blue.mdl", "models/stickynades/stickynades_blue.phy", "models/stickynades/stickynades_blue.sw.vtx", "models/stickynades/stickynades_blue.vvd", "materials/models/stickynades/stickynades_blue.vtf", "materials/models/stickynades/stickynades_blue.vmt", "materials/models/stickynades/stickynades_red.vtf", "materials/models/stickynades/stickynades_red.vmt"]
    if vVars["sn_emit_sounds"] == 1:
        for file in sounds: es.stringtable('downloadables', file)
    if vVars["sn_hegrenade_model"] == 1:
        for file in models: es.stringtable('downloadables', file)

def round_start(event_var):
    if vVars["sn_notice"] == 1:
        es.msg("#multi", "#green[StickyNades]#default is running. Created by #lightgreenJoeyT2008")
        if vVars["sn_hegrenade_enabled"] == 1:
            if vVars["sn_hegrenade_stick_to_walls"] == 1:
                if vVars["sn_hegrenade_stick_to_players"] == 1: es.msg("#multi", "#green[StickyNades]#lightgreen Frag Grenades #defaultstick to #lightgreenwalls #defaultand #lightgreenplayers#default.")
                else: es.msg("#multi", "#green[StickyNades]#lightgreen Frag Grenades #defaultstick to #lightgreenwalls#default.")
            else: es.msg("#multi", "#green[StickyNades]#lightgreen Frag Grenades #defaultstick to #lightgreenplayers#default.")
        if vVars["sn_flashbang_enabled"] == 1:
            if vVars["sn_flashbang_stick_to_walls"] == 1:
                if vVars["sn_flashbang_stick_to_players"] == 1: es.msg("#multi", "#green[StickyNades]#lightgreen Flashbangs #defaultstick to #lightgreenwalls #defaultand #lightgreenplayers#default.")
                else: es.msg("#multi", "#green[StickyNades]#lightgreen Flashbangs #defaultstick to #lightgreenwalls#default.")
            else: es.msg("#multi", "#green[StickyNades]#lightgreen Flashbangs #defaultstick to #lightgreenplayers#default.")

def tickSticky():
    try:
        global vPrepared, oldEntList
        if vVars["sn_hegrenade_enabled"] == 1:
            entList = es.createentitylist("hegrenade_projectile")
            for index in oldEntList:
                if not index in entList: vPrepared.remove(index)
            oldEntList = entList
            for index in entList:
                if not index in vPrepared and objExists(index):
                    userid = getOwner(index)
                    if es.exists("userid", userid):
                        if vVars["sn_hegrenade_model"] == 1:
                            if es.getplayerteam(userid) == 2: es.setindexprop(index, "CBaseEntity.m_nModelIndex", sn_redmodel)
                            if es.getplayerteam(userid) == 3: es.setindexprop(index, "CBaseEntity.m_nModelIndex", sn_bluemodel)
                            es.setindexprop(index, "CBaseEntity.m_clrRender", -1)
                        es.setindexprop(index, "CBaseGrenade.m_flDamage", vVars["sn_hegrenade_normal_power"])
                        es.setindexprop(index, "CBaseGrenade.m_DmgRadius", vVars["sn_hegrenade_normal_radius"])
                        vPrepared.append(index)
    except: pass

def objExists(index):
    try:
        if es.getindexprop(index, "CBaseGrenade.m_hThrower") == None: return False
        else: return True
    except: return False

def grenade_bounce(event_var):
    data = getGrenadeProperties(event_var["userid"])
    if data:
        if vVars["sn_%s_enabled" % data[1]] == 1:
            if vVars["sn_%s_stick_to_walls" % data[1]] == 1: es.setindexprop(data[0], "CBaseEntity.movetype", 0)
            if vVars["sn_%s_stick_to_players" % data[1]] == 1: getTarget(es.getindexprop(data[0], "CBaseEntity.m_vecOrigin"), 80, playerlib.getPlayerList('#all'), event_var["userid"], data[0])

def getTarget(gLoc, minRadius, playerList, userid, index):
    nearid = None
    maxRadius = 50000
    for tID in playerList:
        if (not int(tID.attributes['isdead'])) and int(tID.attributes['teamid'])>1:
                tLoc = vecmath.vector((tID.attributes['x'], tID.attributes['y'], tID.attributes['z']))
                distance = vecmath.distance(tLoc, gLoc)
                if distance <= maxRadius:
                    maxRadius = distance
                    nearid = tID
    if nearid:
        if maxRadius <= minRadius: stickPlayer(int(userid), int(nearid), int(index))

def getGrenadeProperties(userid):
    for grenade in ["hegrenade", "flashbang"]:
        entList = es.createentitylist("%s_projectile" % grenade)
        for index in entList:
            if int(getOwner(index)) == int(userid): return [index, grenade]
    return None

def getOwner(index):
    return es.getuserid(es.getindexprop(index, "CBaseGrenade.m_hThrower"))

def shakePlayer(userid, magnitude, time):
    if es.exists('userid', userid):
        es.usermsg('create', 'shake', 'Shake')
        es.usermsg('write', 'byte', 'shake', 0)
        es.usermsg('write', 'float', 'shake', magnitude)
        es.usermsg('write', 'float', 'shake', 1.0)
        es.usermsg('write', 'float', 'shake', time)
        es.usermsg('send', 'shake', userid)
        es.usermsg('delete','shake')

def stickPlayer(userid, nearid, index):
    gType = None
    for grenade in ["hegrenade", "flashbang"]:
        for tIndex in es.createentitylist("%s_projectile" % grenade):
            if int(tIndex) == int(index): gType = grenade
    if gType:
        if vVars["sn_%s_stick_to_players" % gType] == 1:
            if userid == nearid and vVars["sn_%s_stick_to_thrower" % gType] == 1 or not userid == nearid: es.setindexprop(index, "CBaseEntity.movetype", 0)
            if gType == "hegrenade":
                es.setindexprop(index, "CBaseGrenade.m_flDamage", vVars["sn_hegrenade_stuck_power"])
                es.setindexprop(index, "CBaseGrenade.m_DmgRadius", vVars["sn_hegrenade_stuck_radius"])
                if userid == nearid:
                    if vVars["sn_hegrenade_stick_to_thrower"] == 1: es.msg("#multi", "#green[StickyNades]#lightgreen%s#default stuck himself with a #lightgreenFrag Grenade#default!" % es.getplayername(userid))
                else: es.msg("#multi", "#green[StickyNades]#lightgreen%s#default stuck#lightgreen %s#default with a #lightgreenFrag Grenade#default!" % (es.getplayername(userid), es.getplayername(nearid)))
            if gType == "flashbang":
                if userid == nearid:
                    if vVars["sn_flashbang_stick_to_thrower"] == 1: es.msg("#multi", "#green[StickyNades]#lightgreen%s#default stuck himself with a #lightgreenFlashbang#default!" % es.getplayername(userid))
                else: es.msg("#multi", "#green[StickyNades]#lightgreen%s#default stuck#lightgreen %s#default with a #lightgreenFlashbang#default!" % (es.getplayername(userid), es.getplayername(nearid)))
            if vVars["sn_emit_sounds"] == 1:
                if not userid == nearid:
                    es.emitsound("player", userid, "stickynades/muhahaha.wav", 1, 0.5)
                    es.emitsound("player", nearid, "stickynades/scream.wav", 1, 0.5)
                else:
                    if vVars["sn_%s_stick_to_thrower" % gType] == 1: es.emitsound("player", userid, "stickynades/scream.wav", 1, 0.5)
            if vVars["sn_shake"] == 1:
                if not userid == nearid: shakePlayer(nearid, 50, 1)
                else:
                    if vVars["sn_%s_stick_to_thrower" % gType] == 1: shakePlayer(userid, 50, 1)
            if userid == nearid and vVars["sn_%s_stick_to_thrower" % gType] == 1 or not userid == nearid:
                nade = "nade" + str(nearid)
                if es.exists("variable", "est_version"): es.server.cmd("est_setentname %d %s" % (index, nade))
                else: es.server.cmd("setentname %d %s" % (index, nade))
                user = "user" + str(nearid)
                es.server.cmd('es_fire %s !self addoutput "targetname %s"' % (nearid, user))
                es.server.cmd("es_fire %s %s SetParent %s" % (nearid, nade, user))
                es.server.cmd("es_fire %s %s SetAnimation idle" % (nearid, nade))
                es.server.cmd('es_fire %s %s addoutput "angles 0 0 0"' % (nearid, nade))
                es.server.cmd('es_fire %s %s addoutput "solid 0"' % (nearid, nade))
                es.server.cmd("es_fire %s %s FireUser1" % (nearid, nade))