# ./addons/eventscripts/imitate/imitate.py

import es
from cfglib import AddonCFG
from usermsg import saytext2

class Imitate(object):
    def __init__(self):
        self.confg     = None
        self.textCount = None
        self.players   = {}

    def scriptLoad(self):
        self.config = AddonCFG(es.getAddonPath('imitate') + '/imitate_config.cfg')
        self.config.text('**************************************')
        self.config.text('* Imitate by BackRaw - Configuration *')
        self.config.text('**************************************')
        self.config.text('')
        self.textCount = self.config.cvar('imitate_textcount', 3, 'How often can a player imitate another player?')
        self.config.text('\n')
        self.config.text('**************************************')
        self.config.text('* Imitate by BackRaw - Configuration *')
        self.config.text('**************************************')
        self.config.write()
        self.executeConfig()
        for userid in es.getUseridList():
            self.insertUserid(userid)
        if not es.exists('saycommand', '!imitate'):
            es.regsaycmd('!imitate', 'imitate/saycommand')
        es.ServerVar('imitate_ver', 1.0, "BackRaw's Imitate").makepublic()

    def scriptUnload(self):
        self.removeUserid(clear=True)
        if es.exists('saycommand', '!imitate'):
            es.unregsaycmd('!imitate')

    def executeConfig(self):
        self.config.execute()

    def insertUserid(self, userid):
        self.players[int(userid)] = 0

    def removeUserid(self, userid=0, clear=False):
        if not clear:
            del self.players[int(userid)]
        else:
            self.players.clear()

    def resetPlayers(self):
        for userid in self.players:
            self.players[userid] = 0

    def sayCommand(self, userid, name, text):
        target = int(es.getuserid(name))
        if es.exists('userid', target):
            if userid != target:
                if self.players[userid] < int(self.textCount):
                    self.players[userid] += 1
                    player = es.createplayerlist(target)[target]
                    what   = '#all' if not player['isdead'] else '#dead'
                    saytext2(what, player['index'], '%s\x03%s \x01:  %s' % ('\x01*DEAD* ' if what == '#dead' else '', player['name'], text))
                else:
                    es.tell(userid, '#multi', "#green[#lightgreenImitate#green] #defaultYou've exceeded the limit of 3 imitations per round.")
            else:
                es.tell(userid, '#multi', "#green[#lightgreenImitate#green] #defaultYou can't imitate yourself!")
        else:
            es.tell(userid, '#multi', "#green[#lightgreenImitate#green] #defaultTarget player #green%s #defaultdoesn't exist!" % name)
imitate = Imitate()

def player_activate(ev):
    imitate.insertUserid(ev['userid'])

def player_disconnect(ev):
    imitate.removeUserid(ev['userid'])

def round_start(ev):
    imitate.resetPlayers()

def server_cvar(ev):
    if ev['cvarname'] == 'imitate_textcount':
        imitate.executeConfig()

def saycommand():
    args = str(es.getargs()).split('-')
    imitate.sayCommand(int(es.getcmduserid()), args[0][:len(args[0]) - 1], args[1][1:])

def load():
    imitate.scriptLoad()

def unload():
    imitate.scriptUnload()